package com.company.model;

import com.company.exceptions.InvalidDataException;

public class Instructor extends Person{
    private String initials;
    private LectureContainer lectures;
    private boolean isInitialsValid(String initials){
        if(initials.length() != 4){
            return false;
        }
        return true;
    }
    public Instructor(String initials, String name){
        super(name);
        lectures = new LectureContainer();
        setInitials(initials);
    }


    public  String getInitials() {
        return this.initials;
    }
    public void setInitials(String initials){
        if(isInitialsValid(initials)){
            this.initials = initials;
        }else{
            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
    }
    public LectureContainer  getLectures(){
        return this.lectures;
    }
    public boolean isEqualTo (Instructor obj){
        if(this.initials.equals(obj.initials)){
            return true;
        }
        return false;
    }
    public boolean isEqualTo(String initials) {
        if(this.initials.equals(initials)){
            return true;
        }
        return false;
    }
}
